/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.alternator;

import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.energy.InternalEnergyStorage;
import com.mrh0.createaddition.util.Util;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class AlternatorTileEntity
extends KineticTileEntity {
    protected final InternalEnergyStorage energy;
    private LazyOptional<IEnergyStorage> lazyEnergy;
    private static final int MAX_IN = 0;
    private static final int MAX_OUT = (Integer)Config.ALTERNATOR_MAX_OUTPUT.get();
    private static final int CAPACITY = (Integer)Config.ALTERNATOR_CAPACITY.get();
    private static final int STRESS = (Integer)Config.BASELINE_STRESS.get();
    private static final double EFFICIENCY = (Double)Config.ALTERNATOR_EFFICIENCY.get();
    private boolean firstTickState = true;
    private LazyOptional<IEnergyStorage> escacheUp = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheDown = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheNorth = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheEast = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheSouth = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheWest = LazyOptional.empty();

    public AlternatorTileEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.energy = new InternalEnergyStorage(CAPACITY, 0, MAX_OUT);
        this.lazyEnergy = LazyOptional.of(() -> this.energy);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        tooltip.add((Component)new TextComponent("    ").m_7220_((Component)new TranslatableComponent("createaddition.tooltip.energy.production").m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)new TextComponent("    ").m_7220_((Component)new TextComponent(" " + Util.format(AlternatorTileEntity.getEnergyProductionRate((int)(this.isSpeedRequirementFulfilled() ? this.getSpeed() : 0.0f))) + "fe/t ").m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Lang.translateDirect((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_GRAY)));
        added = true;
        return added;
    }

    public float calculateStressApplied() {
        float impact;
        this.lastStressApplied = impact = (float)STRESS / 256.0f;
        return impact;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.lazyEnergy.cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean isEnergyInput(Direction side) {
        return false;
    }

    public boolean isEnergyOutput(Direction side) {
        return true;
    }

    public void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.energy.read(compound);
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        this.energy.write(compound);
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (this.firstTickState) {
            this.firstTick();
        }
        this.firstTickState = false;
        if (Math.abs(this.getSpeed()) > 0.0f && this.isSpeedRequirementFulfilled()) {
            this.energy.internalProduceEnergy(AlternatorTileEntity.getEnergyProductionRate((int)this.getSpeed()));
        }
        for (Direction d : Direction.values()) {
            IEnergyStorage ies;
            if (!this.isEnergyOutput(d) || (ies = this.getCachedEnergy(d)) == null) continue;
            int ext = this.energy.extractEnergy(ies.receiveEnergy(MAX_OUT, true), false);
            int n = ies.receiveEnergy(ext, false);
        }
    }

    public static int getEnergyProductionRate(int rpm) {
        rpm = Math.abs(rpm);
        return (int)((double)((Integer)Config.FE_RPM.get()).intValue() * ((double)Math.abs(rpm) / 256.0) * EFFICIENCY);
    }

    protected Block getStressConfigKey() {
        return (Block)AllBlocks.MECHANICAL_MIXER.get();
    }

    public void remove() {
        this.lazyEnergy.invalidate();
        super.remove();
    }

    public void firstTick() {
        this.updateCache();
    }

    public void updateCache() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        for (Direction side : Direction.values()) {
            BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_142300_(side));
            if (te == null) {
                this.setCache(side, (LazyOptional<IEnergyStorage>)LazyOptional.empty());
                continue;
            }
            LazyOptional le = te.getCapability(CapabilityEnergy.ENERGY, side.m_122424_());
            this.setCache(side, (LazyOptional<IEnergyStorage>)le);
        }
    }

    public void setCache(Direction side, LazyOptional<IEnergyStorage> storage) {
        switch (side) {
            case DOWN: {
                this.escacheDown = storage;
                break;
            }
            case EAST: {
                this.escacheEast = storage;
                break;
            }
            case NORTH: {
                this.escacheNorth = storage;
                break;
            }
            case SOUTH: {
                this.escacheSouth = storage;
                break;
            }
            case UP: {
                this.escacheUp = storage;
                break;
            }
            case WEST: {
                this.escacheWest = storage;
            }
        }
    }

    public IEnergyStorage getCachedEnergy(Direction side) {
        switch (side) {
            case DOWN: {
                return (IEnergyStorage)this.escacheDown.orElse(null);
            }
            case EAST: {
                return (IEnergyStorage)this.escacheEast.orElse(null);
            }
            case NORTH: {
                return (IEnergyStorage)this.escacheNorth.orElse(null);
            }
            case SOUTH: {
                return (IEnergyStorage)this.escacheSouth.orElse(null);
            }
            case UP: {
                return (IEnergyStorage)this.escacheUp.orElse(null);
            }
            case WEST: {
                return (IEnergyStorage)this.escacheWest.orElse(null);
            }
        }
        return null;
    }
}

